/* 		Motif X-Windows Drawing Library  */

#include "dincludes.h"
#include "dmotif.h"
#include "define.h"

DrawData *drawData = NULL;
Colormap cmap;

ConfigureDrawData(Widget w, DrawData* data)
{
    Arg args[6];
    Dimension width, height, st, ht, mw, mh;
    Dimension totalMarginWidth;
    Dimension totalMarginHeight;

    width = height = st = ht = mw = mh = 0;
    XtSetArg (args[0], XmNwidth, &width);
    XtSetArg (args[1], XmNheight, &height);
    XtSetArg (args[2], XmNshadowThickness, &st);
    XtSetArg (args[3], XmNhighlightThickness, &ht);
    XtSetArg (args[4], XmNmarginWidth, &mw);
    XtSetArg (args[5], XmNmarginHeight, &mh);
    XtGetValues (w, args, 6);

    totalMarginWidth = st + ht + mw;
    totalMarginHeight = st + ht + mh;

    if (2 * totalMarginWidth < width && 2 * totalMarginHeight < height) {
        data->drawX = totalMarginWidth;
        data->drawY = totalMarginHeight;
        data->drawWidth = width - 2 * totalMarginWidth;
        data->drawHeight = height - 2 * totalMarginHeight;
    }
    else {
        data->drawWidth = 0;
        data->drawHeight = 0;
    }
}

GC GetGC( Widget w )
{
    Arg args[2];
    XGCValues gcv;
    Pixel fg;
    Pixel bg;
    GC gc;

    XtSetArg (args[0], XmNforeground, &fg);
    XtSetArg (args[1], XmNbackground, &bg);
    XtGetValues (w, args, 2);
    gcv.foreground = fg;
    gcv.background = bg;
    gcv.line_width = 1;
    gc = XtGetGC (w, GCForeground | GCBackground | GCLineWidth, &gcv);

    return (gc);
}
 
DPoint(Widget w, LONG x, LONG y, UBYTE color)
{
 GC gc=GetGC(w);
 XSetForeground( XtDisplay(w), gc, color);
 XDrawPoint(XtDisplay(w), XtWindow(w),gc,(int)x,(int)y);
} 

DPlot(Widget w,PointP *points,unsigned npoints, UBYTE color)
{
int i;
GC gc=GetGC(w);
XSetForeground( XtDisplay(w), gc, color);
/*for(i=0; i<npoints; i++) {
 XDrawPoint(XtDisplay(w), XtWindow(w),gc,(int)(points[i].x),(int)(points[i].y));
}*/

XDrawPoints(XtDisplay(w), XtWindow(w),gc,(XPoint*)points,npoints,CoordModeOrigin);
}

DRect(Widget w, LONG x, LONG y, LONG l, LONG h, UBYTE color)
{  
 GC gc=GetGC(w);
 XSetForeground( XtDisplay(w), gc, color);
 XDrawRectangle(XtDisplay(w), XtWindow(w),gc,(int)x,(int)y,(int)l,(int)h);
}

DRectXY(Widget w, LONG x1, LONG y1, LONG x2, LONG y2, UBYTE color) 
{
 GC gc=GetGC(w);
 XSetForeground( XtDisplay(w), gc, color);
 XDrawLine(XtDisplay(w), XtWindow(w),gc ,(int)x1,(int)y1,(int)x2,(int)y1);
 XDrawLine(XtDisplay(w), XtWindow(w),gc ,(int)x2,(int)y1,(int)x2,(int)y2);
 XDrawLine(XtDisplay(w), XtWindow(w),gc ,(int)x2,(int)y2,(int)x1,(int)y2);
 XDrawLine(XtDisplay(w), XtWindow(w),gc ,(int)x1,(int)y2,(int)x1,(int)y1);
}

DLine(Widget w, LONG x1, LONG y1, LONG x2, LONG y2, UBYTE color) 
{
 GC gc=GetGC(w);
 XSetForeground( XtDisplay(w), gc, color);
 XDrawLine(XtDisplay(w), XtWindow(w),gc ,(int)x1,(int)y1,(int)x2,(int)y2);
}

DPoly(Widget w,PointP *points,unsigned npoints,UBYTE color) 
{
 GC gc=GetGC(w);
 XSetForeground( XtDisplay(w), gc, color);
 XDrawLines(XtDisplay(w), XtWindow(w),gc,(XPoint*)points,npoints,CoordModeOrigin);   
}

DEllipse(Widget w, LONG x, LONG y, LONG a, LONG b, UBYTE color,UBYTE filled)
{
 GC gc=GetGC(w);
 XSetForeground( XtDisplay(w), gc, color);
 if(filled) {
   XSetArcMode(XtDisplay(w), gc ,ArcPieSlice);
 } else {
   XSetArcMode(XtDisplay(w), gc , ArcChord);
 }
 XDrawArc(XtDisplay(w), XtWindow(w),gc ,(int)x-a,(int)y-b,
          (int)2*a,(int)2*b,0,360<<6);
}

DAskArea(Widget w, PointP *points,unsigned npoints,UBYTE color) 
{
}

DWhereArea(Widget w, PointP *points,unsigned npoints,UBYTE color) 
{
}

DWherePoint(Widget w, LONG *x, LONG *y,UBYTE color, LONG CrossSize)
{
}

int DWhereCursor(Widget w, LONG *x, LONG *y,int button,XmDrawingAreaCallbackStruct *cbs)
{ 
 if(button==((XButtonEvent*)(cbs->event))->button) {
   *x=((XButtonEvent*)(cbs->event))->x;
   *y=((XButtonEvent*)(cbs->event))->y;
   return ((XButtonEvent*)(cbs->event))->type;
 }
 return 0;
} 

DSetGCPaintMode(Widget w, int mode) 
{
 XGCValues values;
 GC gc=GetGC(w);
 values.function=mode;
 XChangeGC(XtDisplay(w), gc, GCFunction, &values);
}

VOID Palette_Gray(Widget w)
{
   LONG i;
  if (drawData == NULL) { 
        cmap=XCreateColormap(XtDisplay(w), XtWindow(w),
                  DefaultVisual(XtDisplay(w), DefaultScreen(XtDisplay(w))),
                  AllocAll);
        drawData = (DrawData *)XtMalloc (sizeof(DrawData));
        drawData->gc = GetGC (w);
        ConfigureDrawData (w, drawData);
  }

   for (i=0;i<256;i++)
      SetRGB_CMap(w,i,i,i,i);

XInstallColormap(XtDisplay(w), cmap);
  XSetWindowColormap(XtDisplay(w),XtWindow(w),cmap);
}
VOID Palette_16M(Widget w)
{
   LONG r,g,b,a=0;
  if (drawData == NULL) { 
        cmap=XCreateColormap(XtDisplay(w), XtWindow(w),
                  DefaultVisual(XtDisplay(w), DefaultScreen(XtDisplay(w))),
                  AllocAll);
        drawData = (DrawData *)XtMalloc (sizeof(DrawData));
        drawData->gc = GetGC (w);
        ConfigureDrawData (w, drawData);
  }

   for (r=0;r<8;r++)
      for (g=0;g<8;g++)
         for (b=0;b<4;b++)
            SetRGB_CMap(w,a++,r<<5,g<<5,b<<6);

XInstallColormap(XtDisplay(w), cmap);
  XSetWindowColormap(XtDisplay(w),XtWindow(w),cmap);
}

VOID Palette_Random_Color(Widget w)
{
   LONG i;
  if (drawData == NULL) { 
        cmap=XCreateColormap(XtDisplay(w), XtWindow(w),
                  DefaultVisual(XtDisplay(w), DefaultScreen(XtDisplay(w))),
                  AllocAll);
        drawData = (DrawData *)XtMalloc (sizeof(DrawData));
        drawData->gc = GetGC (w);
        ConfigureDrawData (w, drawData);
  }

   srand(time(NULL));

   for (i=0;i<256;i++)
   {
      SetRGB_CMap(w,i,rand()%256,rand()%256,rand()%256);
   }
XInstallColormap(XtDisplay(w), cmap);
  XSetWindowColormap(XtDisplay(w),XtWindow(w),cmap);

}

VOID Palette_Smooth_Color(Widget w)
{
   LONG i;
  if (drawData == NULL) { 
        cmap=XCreateColormap(XtDisplay(w), XtWindow(w),
                  DefaultVisual(XtDisplay(w), DefaultScreen(XtDisplay(w))),
                  AllocAll);
        drawData = (DrawData *)XtMalloc (sizeof(DrawData));
        drawData->gc = GetGC (w);
        ConfigureDrawData (w, drawData);
  }

   for (i=0;i<64;i++)
   {
      SetRGB_CMap(w,i,i<<2,0,i<<2);
      SetRGB_CMap(w,i+64,0,i<<2,i<<2);
      SetRGB_CMap(w,i+128,i<<2,i<<2,0);
      SetRGB_CMap(w,i+192,i<<2,i<<2,i<<2);
   }
XInstallColormap(XtDisplay(w), cmap);
  XSetWindowColormap(XtDisplay(w),XtWindow(w),cmap);
}

VOID Palette_Random_Gray(Widget w)
{
   LONG i,a;
  if (drawData == NULL) { 
        cmap=XCreateColormap(XtDisplay(w), XtWindow(w),
                  DefaultVisual(XtDisplay(w), DefaultScreen(XtDisplay(w))),
                  AllocAll);
        drawData = (DrawData *)XtMalloc (sizeof(DrawData));
        drawData->gc = GetGC (w);
        ConfigureDrawData (w, drawData);
  }

   srand(time(NULL));

   for (i=0;i<256;i++)
   {
      a=rand()%256;
      SetRGB_CMap(w,i,a,a,a);
   }
XInstallColormap(XtDisplay(w), cmap);
  XSetWindowColormap(XtDisplay(w),XtWindow(w),cmap);

}

VOID SetRGB_CMap(Widget w,LONG n,LONG r,LONG g,LONG b)
{
   XColor Col;
   Col.pixel = (unsigned long)n;
   Col.red = (unsigned short)r << 8 ;
   Col.green = (unsigned short)g << 8 ;
   Col.blue = (unsigned short)b << 8 ;
   Col.flags = DoRed | DoGreen | DoBlue;

   XStoreColor(XtDisplay(w), cmap, &Col);

}

