/* 		Motif X-Windows Drawing Library   */
#ifndef _DMOTIF_H_
#define _DMOTIF_H_
#include "dincludes.h"
#include "define.h"
typedef struct _DrawData {
        GC gc;
        Position drawX;
        Position drawY;
        Dimension drawWidth;
        Dimension drawHeight;
} DrawData;

extern DrawData *drawData;
extern Colormap cmap;
ConfigureDrawData(Widget w, DrawData* data);
GC GetGC( Widget w );

typedef struct PointS {
	short x;
	short y;
} PointP;

DPoint(Widget w, LONG x, LONG y, UBYTE color);

DPlot(Widget w,PointP *points,unsigned npoints, UBYTE color);

DLine(Widget w, LONG x1, LONG y1, LONG x2, LONG y2, UBYTE color);

DRect(Widget w, LONG x, LONG y, LONG l, LONG h, UBYTE color);

DRectXY(Widget w, LONG x1, LONG y1, LONG x2, LONG y2, UBYTE color); 

DPoly(Widget w,PointP *points,unsigned npoints,UBYTE color); 

DEllipse(Widget w, LONG x, LONG y, LONG a, LONG b, UBYTE color,UBYTE filled);

DAskArea(Widget w, PointP *points,unsigned npoints,UBYTE color); 

DWhereArea(Widget w, PointP *points,unsigned npoints,UBYTE color); 

DWherePoint(Widget w, LONG *x, LONG *y,UBYTE color, LONG CrossSize);

DWhereCursor(Widget w, LONG *x, LONG *y,int button,XmDrawingAreaCallbackStruct *cbs);
  
DSetGCPaintMode(Widget w, int mode);

VOID Palette_Gray(Widget w);

VOID Palette_16M(Widget w);

VOID Palette_Random_Color(Widget w);

VOID Palette_Smooth_Color(Widget w);

VOID Palette_Random_Gray(Widget w);

VOID SetRGB_CMap(Widget w,LONG n,LONG r,LONG g,LONG b);
#endif _DMOTIF_H_
